<?php
    $currentIndent ??= 0;

    if (! view()->exists($paginationView = Theme::getThemeNamespace('partials.pagination'))) {
        $paginationView = 'pagination::bootstrap-5';
    }

    $currentIp = \Botble\Base\Supports\Helper::getIpFromThirdParty();
?>

<div class="fob-comment-list">
    <?php $__currentLoopData = $comments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $comment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php if(! $comment->is_approved && $comment->ip_address !== $currentIp) continue; ?>

        <div id="comment-<?php echo e($comment->getKey()); ?>" class="fob-comment-item">
            <div class="fob-comment-item-inner">
                <div class="fob-comment-item-avatar">
                    <?php if($comment->website): ?>
                        <a href="<?php echo e($comment->website); ?>" target="_blank">
                            <img src="<?php echo e($comment->avatar_url); ?>" alt="<?php echo e($comment->name); ?>">
                        </a>
                    <?php else: ?>
                        <img src="<?php echo e($comment->avatar_url); ?>" alt="<?php echo e($comment->name); ?>">
                    <?php endif; ?>
                </div>
                <div class="fob-comment-item-content">
                    <div class="fob-comment-item-body">
                        <?php if(! $comment->is_approved): ?>
                            <em class="fob-comment-item-pending">
                                <?php echo e(trans('plugins/fob-comment::comment.front.list.waiting_for_approval_message')); ?>

                            </em>
                        <?php endif; ?>
                        <?php if($comment->is_admin): ?>
                            <?php echo BaseHelper::clean($comment->formatted_content); ?>

                        <?php else: ?>
                            <p><?php echo e($comment->formatted_content); ?></p>
                        <?php endif; ?>
                    </div>

                    <div class="fob-comment-item-footer">
                        <div class="fob-comment-item-info">
                            <?php if(\FriendsOfBotble\Comment\Support\CommentHelper::isDisplayAdminBadge() && $comment->is_admin): ?>
                                <span class="fob-comment-item-admin-badge">
                                    <?php if(setting('fob_comment_show_admin_role_name_for_admin_badge', true) && $comment->author?->roles?->value('name')): ?>
                                        <?php echo e($comment->author?->roles?->value('name')); ?>

                                    <?php else: ?>
                                        <?php echo e(trans('plugins/fob-comment::comment.front.admin_badge')); ?>

                                    <?php endif; ?>
                                </span>
                            <?php endif; ?>
                            <?php if($comment->website): ?>
                                <a href="<?php echo e($comment->website); ?>" class="fob-comment-item-author" target="_blank">
                                    <h4 class="fob-comment-item-author"><?php echo e($comment->name); ?></h4>
                                </a>
                            <?php else: ?>
                                <h4 class="fob-comment-item-author"><?php echo e($comment->name); ?></h4>
                            <?php endif; ?>
                            <span class="fob-comment-item-date"><?php echo e($comment->created_at->diffForHumans()); ?></span>
                        </div>

                        <?php if($comment->is_approved): ?>
                            <a
                                href="<?php echo e(route('fob-comment.public.comments.reply', $comment)); ?>"
                                class="fob-comment-item-reply"
                                data-comment-id="<?php echo e($comment->getKey()); ?>"
                                data-reply-to="<?php echo e($replyLabel = trans('plugins/fob-comment::comment.front.list.reply_to', ['name' => $comment->name])); ?>"
                                data-cancel-reply="<?php echo e(trans('plugins/fob-comment::comment.front.list.cancel_reply')); ?>"
                                aria-label="<?php echo e($replyLabel); ?>"
                            >
                                <?php echo e(trans('plugins/fob-comment::comment.front.list.reply')); ?>

                            </a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <?php if($comment->replies->isNotEmpty()): ?>
                <?php echo $__env->make('plugins/fob-comment::partials.list', [
                    'comments' => $comment->replies,
                    'currentIndent' => $currentIndent + 1,
                ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            <?php endif; ?>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div>

<?php if($comments instanceof \Illuminate\Contracts\Pagination\LengthAwarePaginator && $comments->hasPages()): ?>
    <div class="fob-comment-pagination">
        <?php echo e($comments->appends(request()->except('page'))->links($paginationView)); ?>

    </div>
<?php endif; ?>
<?php /**PATH /home/creativedesignbd/portfolio.creativedesign.com.bd/platform/plugins/fob-comment/resources/views/partials/list.blade.php ENDPATH**/ ?>