<?php
    Theme::asset()->add('fob-comment-css', asset('vendor/core/plugins/fob-comment/css/comment.css'), version: '1.1.19');
    Theme::asset()->container('footer')->add('fob-comment-js', asset('vendor/core/plugins/fob-comment/js/comment.js'), ['jquery'], version: '1.1.19');

    Theme::registerToastNotification();

    use FriendsOfBotble\Comment\Forms\Fronts\CommentForm;
?>

<script>
    window.fobComment = {};

    window.fobComment = {
        listUrl: <?php echo e(Js::from(route('fob-comment.public.comments.index', isset($model) ? ['reference_type' => $model::class, 'reference_id' => $model->id] : url()->current()))); ?>,
    };
</script>

<div class="fob-comment-list-section" style="display: none">
    <h4 class="fob-comment-title fob-comment-list-title"></h4>
    <div class="fob-comment-list-wrapper"></div>
</div>

<div class="fob-comment-form-section">
    <h4 class="fob-comment-title fob-comment-form-title">
        <span class="d-inline-block"><?php echo e(trans('plugins/fob-comment::comment.front.form.title')); ?></span>
    </h4>
    <p class="fob-comment-form-note"><?php echo e(trans('plugins/fob-comment::comment.front.form.description')); ?></p>

    <?php echo CommentForm::createWithReference($model)->renderForm(); ?>

</div>
<?php /**PATH /home/creativedesignbd/portfolio.creativedesign.com.bd/platform/plugins/fob-comment/resources/views/comment.blade.php ENDPATH**/ ?>