<?php
    Theme::set('pageTitle', $post->name);
?>

<section class="<?php echo \Illuminate\Support\Arr::toCssClasses(['section-details pb-100', 'pt-80' => get_header_style() != 2, 'pt-160' => get_header_style() == 2]); ?>">
    <div class="container">
        <div class="row">
            <div class="col-xl-8 mx-lg-auto mb-8">
                <div class="text-center">
                    <?php if($post->firstCategory): ?>
                        <a href="<?php echo e($post->firstCategory->url); ?>" class="btn btn-gradient d-inline-block text-uppercase"><?php echo e($post->firstCategory->name); ?></a>
                    <?php endif; ?>
                    <h3 class="ds-3 mt-3 mb-4 text-dark"><?php echo BaseHelper::clean($post->name); ?></h3>
                    <p class="text-300 fs-5 mb-0"><?php echo BaseHelper::clean(nl2br($post->description)); ?></p>
                </div>
            </div>
            <?php if($post->image && theme_option('show_blog_post_featured_image', 'yes') !== 'no'): ?>
                <?php echo e(RvMedia::image($post->image, $post->name, attributes: ['class' => 'blog-post-featured-image'])); ?>

            <?php endif; ?>
            <div class="col-xl-10 mx-lg-auto mt-8">
                <div class="row">
                    <div class="col-xl-9">
                        <div class="ck-content">
                            <?php echo BaseHelper::clean($post->content); ?>

                        </div>

                        <?php if($post->tags->isNotEmpty()): ?>
                            <?php
                                if (is_plugin_active('language') && is_plugin_active('language-advanced')) {
                                    $post->tags->loadMissing('translations');
                                }
                            ?>
                            <span class="d-inline-block mb-4">
                                <?php echo BaseHelper::renderIcon('ti ti-tags'); ?>

                                <?php $__currentLoopData = $post->tags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <a href="<?php echo e($tag->url); ?>" class="me-0"><?php echo e($tag->name); ?></a><?php if(!$loop->last): ?>, <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </span>
                        <?php endif; ?>
                    </div>
                    <div class="col-xl-3 col-md-6 col-12">
                        <div class="border-linear-3 rounded-4 p-lg-6 p-md-4 p-3 mt-lg-0 mt-4">
                            <div class="d-flex align-items-center mb-3">
                                <i class="ri-time-line fs-6"></i>
                                <span class="ms-2 fs-6"><?php echo e(__(':time min read', ['time' => $post->time_reading])); ?></span>
                            </div>
                            <div class="d-flex align-items-center mb-3">
                                <i class="ri-calendar-schedule-line fs-6"></i>
                                <span class="ms-2 fs-6"><?php echo e(Theme::formatDate($post->created_at)); ?></span>
                            </div>
                            <div class="d-flex align-items-center mb-3">
                                <i class="ri-user-line fs-6"></i>
                                <span class="ms-2 fs-6"><?php echo BaseHelper::clean(__('By :author', ['author' => "<span class='fw-bold'>{$post->author->name}</span<"])); ?></span>
                            </div>
                        </div>
                        <div class="border-linear-3 rounded-4 p-lg-6 p-md-4 p-3 mt-4 mb-3">
                            <span class="text-uppercase fs-7 me-2"><?php echo e(__('Share')); ?></span> <br />
                            <?php echo Theme::renderSocialSharing($post->url, SeoHelper::getDescription(), $post->image); ?>

                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-xl-9">
                        <br>
                        <?php echo apply_filters(BASE_FILTER_PUBLIC_COMMENT_AREA, null, $post); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<?php
    $relatedPosts = get_related_posts($post->getKey(), 3);
?>

<?php if($relatedPosts->isNotEmpty()): ?>
    <section class="section-blog-list">
        <div class="container border-top pt-80 pb-80">
            <h1 class="text-300"><?php echo e(__('Related posts')); ?></h1>

            <?php
                $itemsPerRow = theme_option('post_item_per_row', 3);
            ?>

            <div class="<?php echo \Illuminate\Support\Arr::toCssClasses(['row mt-8', "row-cols-1 row-cols-md-{$itemsPerRow}"]); ?>">
                <?php $__currentLoopData = $relatedPosts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php echo $__env->make(Theme::getThemeNamespace('views.templates.post-item.index'), array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </section>
<?php endif; ?>
<?php /**PATH /home/creativedesignbd/portfolio.creativedesign.com.bd/platform/themes/zelio/views/post.blade.php ENDPATH**/ ?>