<!DOCTYPE html>
<html <?php echo Theme::htmlAttributes(); ?>>
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=5, user-scalable=1" name="viewport" />

        <?php echo Theme::header(); ?>


        <style>
            :root {
                --primary-color: <?php echo e($primaryColor = theme_option('primary_color', '#6e4ef2')); ?>;
                --gradient-color: <?php echo e(theme_option('gradient_color', '#8c71ff')); ?>;
                --bs-primary-rgb: <?php echo e(implode(', ', BaseHelper::hexToRgb($primaryColor))); ?>;
            }
        </style>
    </head>

    <body <?php echo Theme::bodyAttributes(); ?>>
        <?php echo apply_filters(THEME_FRONT_BODY, null); ?>


        <?php echo Theme::partial('header'); ?>


        <?php echo Theme::partial('preloader'); ?>


        <?php echo $__env->yieldContent('content'); ?>

        <?php echo Theme::partial('footer'); ?>


        <?php echo Theme::footer(); ?>

    </body>
</html>
<?php /**PATH /home/creativedesignbd/portfolio.creativedesign.com.bd/platform/themes/zelio/layouts/base.blade.php ENDPATH**/ ?>