<section id="contact" class="section-contact-2 position-relative pb-60 overflow-hidden">
    <div class="container position-relative z-1">
        <div class="row align-items-center">
            <div class="<?php echo \Illuminate\Support\Arr::toCssClasses(['pb-5 pb-lg-0', 'col-lg-7' => $contactInfo, 'col-lg-12' => ! $contactInfo]); ?>">
                <div class="position-relative">
                    <div class="position-relative z-2">
                        <?php if($shortcode->title): ?>
                            <h3 class="text-primary-2 mb-3"><?php echo BaseHelper::clean($shortcode->title); ?></h3>
                        <?php endif; ?>
                        <?php if($shortcode->subtitle): ?>
                            <span class="fs-5 fw-medium text-200">
                                <?php echo BaseHelper::clean(nl2br($shortcode->subtitle)); ?>

                            </span>
                        <?php endif; ?>
                        <?php echo /** @var \Botble\Contact\Forms\Fronts\ContactForm $form **/
                            $form
                                ->setFormInputClass('form-control bg-3 border border-1 rounded-3')
                                ->setFormLabelClass('mb-3 mt-3 text-dark')
                                ->remove('submit')
                                ->add(
                                    'submit',
                                    'submit',
                                    \Botble\Base\Forms\FieldOptions\ButtonFieldOption::make()
                                        ->cssClass('btn btn-primary-2 rounded-2 mt-3')
                                        ->label(__('Send Message') . '<i class="ri-arrow-right-up-line"></i>')
                                )
                                ->renderForm(); ?>

                    </div>
                    <div class="z-0 bg-primary-dark rectangle-bg z-1 rounded-3"></div>
                </div>
            </div>
            <?php if($contactInfo): ?>
                <div class="col-lg-5 d-flex flex-column ps-lg-8">
                    <?php $__currentLoopData = $contactInfo; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="d-flex align-items-center mb-3 position-relative d-inline-flex">
                            <?php if($item['icon']): ?>
                                <div class="d-inline-block">
                                    <div class="icon-flip flex-nowrap icon-shape icon-xxl border border-1 rounded-3 bg-3">
                                        <?php if (isset($component)) { $__componentOriginal73995948b3bd877b76251b40caf28170 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal73995948b3bd877b76251b40caf28170 = $attributes; } ?>
<?php $component = Botble\Icon\View\Components\Icon::resolve(['name' => $item['icon']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('core::icon'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Botble\Icon\View\Components\Icon::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'text-primary-2']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal73995948b3bd877b76251b40caf28170)): ?>
<?php $attributes = $__attributesOriginal73995948b3bd877b76251b40caf28170; ?>
<?php unset($__attributesOriginal73995948b3bd877b76251b40caf28170); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal73995948b3bd877b76251b40caf28170)): ?>
<?php $component = $__componentOriginal73995948b3bd877b76251b40caf28170; ?>
<?php unset($__componentOriginal73995948b3bd877b76251b40caf28170); ?>
<?php endif; ?>
                                    </div>
                                </div>
                            <?php endif; ?>
                            <div class="ps-3 h-100">
                                <?php if($item['label']): ?>
                                    <span class="text-400 fs-6"><?php echo e($item['label']); ?></span>
                                <?php endif; ?>
                                <?php if($item['content']): ?>
                                    <h6 class="mb-0"><?php echo e($item['content']); ?></h6>
                                <?php endif; ?>
                            </div>
                            <?php if($item['url']): ?>
                                <a href="<?php echo e($item['url']); ?>" class="position-absolute top-0 start-0 w-100 h-100" title="<?php echo e($item['label']); ?>"></a>
                            <?php endif; ?>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
</section>
<?php /**PATH /home/creativedesignbd/portfolio.creativedesign.com.bd/platform/themes/zelio/partials/shortcodes/contact-form/styles/style-2.blade.php ENDPATH**/ ?>