
<?php
    $list = Shortcode::fields()->getTabsData(['label', 'content'], $shortcode, 'list');
?>

<section id="skills" class="section-skills-2 pt-5">
    <div class="container">
        <div class="rounded-3 bg-3 border border-1 position-relative overflow-hidden">
            <div class="position-relative z-1 py-60">
                <div class="position-relative z-1">
                    <?php if($shortcode->title || $shortcode->subtitle): ?>
                        <div class="text-center">
                            <?php if($shortcode->subtitle): ?>
                                <div class="d-flex align-items-center justify-content-center">
                                    <svg class="text-primary-2 me-2" xmlns="http://www.w3.org/2000/svg" width="5" height="6" viewBox="0 0 5 6" fill="none">
                                        <circle cx="2.5" cy="3" r="2.5" fill="var(--primary-color)" />
                                    </svg>
                                    <span class="text-linear-4 d-flex align-items-center"><?php echo BaseHelper::clean(nl2br($shortcode->subtitle)); ?></span>
                                </div>
                            <?php endif; ?>
                            <?php if($shortcode->title): ?>
                                <h3><?php echo BaseHelper::clean($shortcode->title); ?></h3>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                    <div class="container mt-8">
                        <div class="row">
                            <?php if($tabs): ?>
                                <div class="<?php echo \Illuminate\Support\Arr::toCssClasses(['col-lg-6' => $list, 'col-lg-12' => ! $list]); ?>">
                                    <div class="row">
                                        <?php $__currentLoopData = collect($tabs)->split(2); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="<?php echo \Illuminate\Support\Arr::toCssClasses(['mx-auto overflow-hidden', 'col-lg-10 col-md-9' => $loop->first, 'col-lg-8 col-md-7 col-10' => ! $loop->first]); ?>">
                                                <div class="carouselTicker carouselTicker-right position-relative z-1">
                                                    <ul class="carouselTicker__list m-0">
                                                        <?php $__currentLoopData = $row; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tab): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <li class="carouselTicker__item mt-6">
                                                                <div class="brand-logo icon_80 icon-shape rounded-3">
                                                                    <?php echo e(RvMedia::image($tab['image'], $tab['name'])); ?>

                                                                </div>
                                                                <span class="tool-tip"><?php echo e($tab['name']); ?></span>
                                                            </li>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </ul>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            <?php endif; ?>
                            <?php if($list): ?>
                                <div class="<?php echo \Illuminate\Support\Arr::toCssClasses(['border-start-md mt-lg-0 mt-5', 'col-lg-6' => $tabs, 'col-lg-12' => ! $tabs]); ?>">
                                    <div class="row">
                                        <div class="col-md-10 mx-auto">
                                            <div class="h-100 position-relative">
                                                <ul class="ps-3 d-flex flex-column justify-content-between h-100 position-relative">
                                                    <?php $__currentLoopData = $list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <li class="mb-3">
                                                            <div class="d-flex flex-column flex-md-row gap-2">
                                                                <p class="text-dark text-nowrap mb-0"><?php echo e($item['label']); ?></p>
                                                                <span class="text-300"><?php echo e($item['content']); ?></span>
                                                            </div>
                                                        </li>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="position-absolute d-none d-md-block decorate">
                <div class="rotateme">
                    <div class="circle-1-1"></div>
                    <div class="circle-1-2 position-absolute top-50 start-50 translate-middle">
                        <svg class="mb-5 position-absolute bottom-0 start-0" xmlns="http://www.w3.org/2000/svg" width="9" height="9" viewBox="0 0 9 9" fill="none">
                            <circle cx="4.5" cy="4.5" r="4.5" fill="#636366" />
                        </svg>
                    </div>
                    <div class="circle-1-3 position-absolute top-50 start-50 translate-middle">
                        <svg class="mb-3 position-absolute bottom-0 end-0" xmlns="http://www.w3.org/2000/svg" width="9" height="9" viewBox="0 0 9 9" fill="none">
                            <circle cx="4.5" cy="4.5" r="4.5" fill="#636366" />
                        </svg>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php /**PATH /home/sardarit/public_html/platform/themes/zelio/partials/shortcodes/skills/styles/style-2.blade.php ENDPATH**/ ?>