<section id="portfolio" class="section-experience pt-5">
    <div class="container">
        <div class="rounded-3 border border-1 position-relative overflow-hidden">
            <div class="box-linear-animation position-relative z-1">
                <div class="p-lg-8 p-md-6 p-3 position-relative z-1">
                    <?php if($shortcode->subtitle): ?>
                        <div class="d-flex align-items-center">
                            <svg class="text-primary-2 me-2" xmlns="http://www.w3.org/2000/svg" width="5" height="6" viewBox="0 0 5 6" fill="none">
                                <circle cx="2.5" cy="3" r="2.5" fill="var(--primary-color)" />
                            </svg>
                            <span class="text-linear-4 d-flex align-items-center">
                                <?php echo BaseHelper::clean($shortcode->subtitle); ?>

                            </span>
                        </div>
                    <?php endif; ?>
                    <?php if($shortcode->title): ?>
                        <h3><?php echo BaseHelper::clean($shortcode->title); ?></h3>
                    <?php endif; ?>
                    <div class="row mt-5">
                        <?php if($experiences): ?>
                            <div class="col-lg-4">
                                <div class="d-flex flex-column gap-2">
                                    <?php $__currentLoopData = $experiences; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $experience): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="technology border border-1 rounded-3 p-3">
                                            <div class="d-flex align-items-center gap-2">
                                                <?php echo e(RvMedia::image($experience['logo'], $experience['title'])); ?>

                                                <div class="d-flex flex-column ms-2">
                                                    <h5 class="mb-1"><?php echo e($experience['title']); ?></h5>
                                                    <span class="text-300"><?php echo e($experience['date']); ?></span>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        <?php endif; ?>
                        <div class="<?php echo \Illuminate\Support\Arr::toCssClasses(['mt-5 ps-lg-5 mt-lg-0', 'col-lg-8' => $experiences, 'col-lg-12' => ! $experiences]); ?>">
                            <h6 class="text-linear-4"><?php echo BaseHelper::clean($shortcode->role_title); ?></h6>
                            <?php
                                $descriptionItems = array_filter(explode("\n", $shortcode->role_description));
                            ?>
                            <?php if($descriptionItems): ?>
                                <ul class="mt-4">
                                    <?php $__currentLoopData = $descriptionItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $descriptionItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="text-dark mb-3"><?php echo BaseHelper::clean($descriptionItem); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            <?php endif; ?>
                            <?php if($skills): ?>
                                <div class="d-flex flex-wrap align-items-center gap-3 mt-7">
                                    <?php $__currentLoopData = $skills; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $skill): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="text-300 border border-1 px-3 py-1"><?php echo e($skill['name']); ?></div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <?php if($shortcode->background_image): ?>
                    <?php echo e(RvMedia::image($shortcode->background_image, $shortcode->title, attributes: ['class' => 'position-absolute top-0 start-0 z-0'])); ?>

                <?php endif; ?>
            </div>
        </div>
    </div>
</section>
<?php /**PATH /home/creativedesignbd/portfolio.creativedesign.com.bd/platform/themes/zelio/partials/shortcodes/experience/index.blade.php ENDPATH**/ ?>